package gov.va.med.mhv.rxrefill.converter;

import gov.va.med.mhv.rxrefill.data.model.Request;
import gov.va.med.mhv.rxrefill.dto.RequestDTO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

@Component
public class RequestConverter implements Serializable {

	private static final long serialVersionUID = -5996243023378509139L;

	public RequestDTO convertDomainRequest(Request request) {
		RequestDTO requestDto = new RequestDTO();
		
		requestDto.setRequestId(request.getId());
		requestDto.setOplock(request.getOplock());
		requestDto.setCreatedDate(request.getCreatedDate());
		requestDto.setIsInactive(request.getIsInactive());
		requestDto.setExceededMaxFailedAttempts(request.getExceededMaxFailedAttempts());
		requestDto.setStartDate(request.getStartDate());
		requestDto.setUserId(request.getUserId());
		/*if (null != request.getUserProfile()) {
			requestDto.setUserProfile(new UserProfileConverter().convertDomainUserProfile(request.getUserProfile()));
		}*/
		requestDto.setRequestFunction(request.getRequestFunction());
		requestDto.setModifiedDate(request.getModifiedDate());
		requestDto.setStatus(request.getStatus());
		requestDto.setEndDate(request.getEndDate());
		requestDto.setInstitutionId(request.getInstitutionId());
		
		if (null != request.getInstitution()) {
			requestDto.setInstitution(new InstitutionConverter().convertDomainInstitution(request.getInstitution()));
		}
		
		return requestDto;
	}
	
	public List<RequestDTO> convertDomainRequestList(List<Request> source) {
		List <RequestDTO> requestDto= null;
		if(null !=source) {
			requestDto = new ArrayList<RequestDTO>();

			for (Request request: source) {
				requestDto.add(this.convertDomainRequest(request));
			}

		}
		return requestDto;
	}

}
